<?php

define('FIFU_JETPACK_SIZES', serialize(array(75, 100, 150, 240, 320, 500, 640, 800, 1024, 1280, 1600)));

function is_from_jetpack($url) {
    return strpos($url, ".wp.com") !== false;
}

function fifu_resize_jetpack_image_size($size, $url) {
    $size = (int) $size;

    if (strpos($url, 'resize=')) {
        $aux = explode('resize=', $url)[1];
        $aux = explode(',', $aux);
        $w = (int) $aux[0];
        $h = (int) $aux[1];
        $new_h = intval($size * $h / $w);
        $clean_url = explode('?', $url)[0];
        return "{$clean_url}?resize={$size},{$new_h}";
    }

    return "{$url}?w={$size}&resize={$size}";
}

function fifu_jetpack_get_set($url, $is_slider) {
    $quality = $is_slider ? 1.25 : 1;
    $set = '';
    $count = 0;
    foreach (unserialize(FIFU_JETPACK_SIZES) as $i)
        $set .= (($count++ != 0) ? ', ' : '') . fifu_resize_jetpack_image_size($i * $quality, $url) . ' ' . $i . 'w';
    return $set;
}

function fifu_jetpack_blocked($url) {
    if (fifu_is_photon_url($url))
        return true;

    $blocklist = array('amazon-adsystem.com', 'sapo.io', 'unsplash.com', 'i.guim.co.uk', 's.yimg.com', 's1.yimg.com', 'www.washingtonpost.com', 'pbs.twimg.com', 'www.aljazeera.com', 'image.influenster.com', 'api.screenshotmachine.com', 'rackcdn.com', 'googleusercontent.com', 'drive.google.com');
    foreach ($blocklist as $domain) {
        if (strpos($url, $domain) !== false)
            return true;
    }
    return false;
}

function fifu_jetpack_ssl($url) {
    $list = array('m.media-amazon.com', 'images-na.ssl-images-amazon.com');
    foreach ($list as $domain) {
        if (strpos($url, $domain) !== false)
            return true;
    }
    return false;
}

function fifu_is_photon_url($url) {
    $list = array('i0.wp.com', 'i1.wp.com', 'i2.wp.com', 'i3.wp.com');
    foreach ($list as $domain) {
        if (strpos($url, $domain) !== false)
            return true;
    }
    return false;
}

function fifu_jetpack_crop($url, $w, $h, $p, $q) {
    $w = (float) $w;
    $h = (float) $h;
    $p = (float) $p;
    $q = (float) $q;

    if ($p != $q) {
        if (($p / $q) >= ($w / $h)) {
            $a = $w;
            $b = $w * $q / $p;
            $x = 0;
            $y = ($h - $b) / 2;
        } else {
            $b = $h;
            $a = $h * $p / $q;
            $x = ($w - $a) / 2;
            $y = 0;
        }
    } elseif ($p == $q) {
        if ($w >= $h) {
            $b = $h;
            $a = $h;
            $x = ($w - $a) / 2;
            $y = 0;
        } else {
            $a = $w;
            $b = $w;
            $x = 0;
            $y = ($h - $b) / 2;
        }
    }
    return sprintf('%s&crop=%spx,%spx,%spx,%spx', $url, $x, $y, $a, $b);
}

function fifu_jetpack_photon_url($url, $args) {
    if (fifu_is_photon_url($url))
        return $url;

    if (fifu_ends_with($url, '.svg'))
        return $url;

    if (fifu_jetpack_ssl($url))
        $args['ssl'] = 1;

    $url = fifu_remove_cdn_prefix($url);
    $image_url_parts = wp_parse_url($url);
    if (!is_array($image_url_parts) || empty($image_url_parts['host']) || empty($image_url_parts['path']))
        return $url;
    $subdomain = abs(crc32($url) % 4);
    $host = $image_url_parts['host'];
    $path = $image_url_parts['path'];
    $photon_url = "https://i{$subdomain}.wp.com/{$host}{$path}";
    if ($args)
        return add_query_arg($args, $photon_url);
    return $photon_url;
}

function fifu_remove_cdn_prefix($url) {
    if (strpos($url, '%3A%2F%2F') !== false)
        $url = urldecode($url);

    $aux = preg_split('/[\/=]https:\/\//', $url);
    if (sizeof($aux) > 1)
        return 'https://' . $aux[1];

    $aux = preg_split('/[\/=]http:\/\//', $url);
    if (sizeof($aux) > 1)
        return 'http://' . $aux[1];

    return $url;
}

