jQuery(document).ready(function ($) {

    jQuery('table.variations tbody tr td select').on('change', function () {
        ids = null;
        jQuery('table.variations tbody tr td select').each(function (index) {
            attr_name = jQuery(this).attr('name');
            attr_val = jQuery(this).val();

            // continue
            if (!attr_val)
                return;

            if (!ids) {
                ids = fifuVariableVars.attribute_map[attr_name][attr_val];
            } else {
                tmp = fifuVariableVars.attribute_map[attr_name][attr_val];
                ids = ids.filter(value => tmp.includes(value))
            }
        });

        // main
        if (!ids) {
            ids = [fifuVariableVars.post_id];
        } else {
            hasImages = false;
            for (i = 0; i < ids.length; i++) {
                if (fifuVariableVars.url_map[ids[i]][0]) {
                    hasImages = true;
                    break;
                }
            }
            if (!hasImages)
                ids = [fifuVariableVars.post_id];
        }

        style = jQuery('#image-gallery').attr('style');
        galParent = jQuery('.fifu-product-gallery').parent().parent().parent();
        galParent.empty();
        galParent.html('<ul id="image-gallery" class="gallery list-unstyled fifu-product-gallery lightSlider"></ul>');

        // add
        urlset = new Set()
        for (i = 0; i < ids.length; i++) {
            for (j = 0; j < fifuVariableVars.url_map[ids[i]].length; j++) {
                if (fifuVariableVars.url_map[ids[i]][0]) {
                    clazz = (i == 0 && j == 0) ? "lslide active" : "lslide";
                    url = fifuVariableVars.url_map[ids[i]][j];

                    // avoid duplicated urls
                    if (urlset.has(url))
                        continue;
                    urlset.add(url);

                    if (fifuVariableVars.fifu_lazy && url.includes('.wp.com')) {
                        thumb_url = `${url}?w=175&resize=175`;
                        srcset = fifuVariableVars.srcset_map[url];
                        jQuery('.fifu-product-gallery').append('<li data-thumb="' + thumb_url + '" data-src="' + FIFU_PLACEHOLDER + '" data-srcset="' + srcset + '" class="' + clazz + '"><img fifu-replaced="1" data-src="' + thumb_url + '" data-srcset="' + srcset + '" data-sizes="auto" class="lazyload">' + '</li>');
                    } else
                        jQuery('.fifu-product-gallery').append('<li data-thumb="' + url + '" data-src="' + url + '" class="' + clazz + '"><img fifu-replaced="1" src="' + url + '" class="fifu">' + '</li>');
                }
            }
        }

        fifu_slider = fifu_load_slider();
        if (fifuVariableVars.fifu_video)
            replaceVideoThumb($);
    });

});
