(function () {
    window.lazySizesConfig = window.lazySizesConfig || {};
    window.lazySizesConfig.loadMode = 1;
    window.lazySizesConfig.expand = 1;
    window.lazySizesConfig.expFactor = 0.1;
    window.lazySizesConfig.hFac = fifuLazyVars.fifu_horizontal_expansion ? 4000 : 0.1;
    window.lazySizesConfig.throttleDelay = 0;
    window.lazySizesConfig.lazyClass = 'lazyload';
    window.lazySizesConfig.loadingClass = 'lazyloading';
    window.lazySizesConfig.loadedClass = 'lazyloaded';
})();

// 1920x1: https://png-pixel.com/
const FIFU_PLACEHOLDER = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAJxAAAAABCAQAAADS13yAAAAAK0lEQVR42u3BIQEAAAACIP1/2hsGoAEAAAAAAAAAAAAAAAAAAAAAAADgwgCcQgACWbaCCgAAAABJRU5ErkJggg==';

function fifu_lazy(selector = 'img') {
    jQuery(selector).each(function (index) {

        // fix some lazy load themes: sober
        src = jQuery(this).attr('src');
        if (src && src.includes('cdn.fifu.app'))
            jQuery(this).removeClass('lazyloading');

        if (jQuery(this).hasClass('lazyload') || jQuery(this).hasClass('lazyloaded') || jQuery(this).hasClass('lazyloading'))
            return;

        // remove wp lazy load
        jQuery(this).removeAttr('loading');

        if (fifuLazyVars.fifu_show_placeholder && !jQuery(this).hasClass('fifu'))
            fifu_add_placeholder(this);

        // dont touch on slider
        if (!jQuery(this).hasClass('fifu'))
            fifu_add_lazyload(this);
    });
    fifu_add_srcset(selector);
}

function fifu_add_lazyload($) {
    jQuery($).addClass('lazyload');
}

function fifu_add_placeholder($) {
    src = jQuery($).attr('src');
    datasrc = jQuery($).attr('data-src');

    if (src && src.includes('cdn.fifu.app')) {
        jQuery($).attr('data-src', src);
        jQuery($).removeAttr('src');
        datasrc = src;
        src = null;
    }

    if (!src && datasrc) {
        if (datasrc.includes('cdn.fifu.app')) {
            parameters = datasrc.split(/.resize=/)[1];

            if (!parameters)
                parameters = datasrc.split('?theme-size=')[1];

            if (!parameters) {
                id = datasrc.split('/')[4];
                width = parseInt(id.split('-')[1]);
                height = parseInt(id.split('-')[2]);
            } else {
                width = parseInt(parameters.split(',')[0]);
                height = parseInt(parameters.split(',')[1]);
            }

            if (width && height) {
                jQuery($).attr('src', `https://images.placeholders.dev/?width=${width}&height=${height}&text=${'...'}`);
            }
        } else {
            if (fifuLazyVars.fifu_is_product && !datasrc.includes('.fifu.app') && jQuery($).hasClass('lazyload')) {
                if (jQuery($).parents('.woocommerce-product-gallery__wrapper').length == 0)
                    jQuery($).attr('src', FIFU_PLACEHOLDER);
            }
        }
    }
}

var crc32 = function (r) {
    for (var a, o = [], c = 0; c < 256; c++) {
        a = c;
        for (var f = 0; f < 8; f++)
            a = 1 & a ? 3988292384 ^ a >>> 1 : a >>> 1;
        o[c] = a
    }
    for (var n = -1, t = 0; t < r.length; t++)
        n = n >>> 8 ^ o[255 & (n ^ r.charCodeAt(t))];
    return(-1 ^ n) >>> 0
};

function fifu_add_srcset(selector) {
    types = ['src', 'data-src'];
    for (i = 0; i < types.length; i++) {
        // speedup
        new_selector = selector != 'img' ? selector : 'img[' + types[i] + '^="https://cdn.fifu.app/"]';
        jQuery(new_selector).each(function (index) {
            src = jQuery(this).attr(types[i]);
            srcset = jQuery(this).attr(types[i] + 'set');
            // imgId = src.split('/')[4].split('?')[0];
            // original_width = parseInt(src.split('-')[1]);
            // original_height = parseInt(src.split('-')[2]);
            // theme_width = null;

            // // crop
            // crop = src.includes('resize=');
            // if (crop) {
            //     parameters = src.split(/.resize=/)[1].split('&')[0];
            //     theme_width = parseInt(parameters.split(',')[0]);
            //     theme_height = parseInt(parameters.split(',')[1]);
            //     src = src.split('?')[0];
            //     server = crc32(src) % 4;
            //     src = src.replace('//', `//i${server}.wp.com/`);
            // } else if (src.includes('?theme-size=')) {
            //     parameters = src.split('?theme-size=')[1];
            //     theme_width = parseInt(parameters.split(',')[0]);
            //     theme_height = parseInt(parameters.split(',')[1]);
            //     src = src.split('?')[0];
            // }

            if (!srcset && src && src.includes('cdn.fifu.app')) {
                //     pattern = /[^\/]+[.]webp/g;
                //     srcset = '';
                //     sizes = [75, 100, 150, 240, 320, 500, 640, 800, 1024, 1280, 1600];
                //     for (j = 0; j < sizes.length && sizes[j] <= original_width && (theme_width && sizes[j] <= theme_width); j++) {
                //         w = sizes[j];
                //         file_name = w;
                //         if (crop) {
                //             h = parseInt(w * theme_height / theme_width);
                //             // fix bad resolution
                //             if (h < theme_height)
                //                 file_name = 'original';
                //             srcset += ((j != 0) ? ', ' : '') + src.replace(pattern, `${file_name}.webp?resize=${w},${h}`) + ` ${w}w`;
                //         } else
                //             srcset += ((j != 0) ? ', ' : '') + src.replace(pattern, `${w}.webp`) + ` ${w}w`;
                //     }

                // jQuery(this).attr(types[i] + 'set', srcset);
                srcset = fifuCloudVars.srcsets[src];
                srcset = srcset ? srcset : fifuCloudVars.srcsets[src.split('?')[0]];
                if (srcset) {
                    jQuery(this).attr(types[i] + 'set', srcset);
                    jQuery(this).attr('data-sizes', 'auto');
                }
            }
        });

        // flickr
        if (fifuLazyVars.fifu_flickr) {
            jQuery('img[' + types[i] + '*="staticflickr.com"]').each(function (index) {
                src = jQuery(this).attr(types[i])
                srcset = jQuery(this).attr(types[i] + 'set');

                if (!srcset && !src.includes('_h.jpg') && !src.includes('k.jpg')) {
                    srcset = '';
                    sizes = [75, 100, 150, 240, 320, 500, 640, 800, 1024];
                    char_sizes = ['s', 't', 'q', 'm', 'n', '-', 'z', 'c', 'b'];
                    for (j = 0; j < sizes.length; j++)
                        srcset += ((j != 0) ? ', ' : '') + src.replace(/([_][a-z]){0,1}_d.jpg/, '_' + char_sizes[j] + '_d.jpg') + ' ' + sizes[j] + 'w';
                    srcset = srcset.replace(/\_\-/g, '');
                    jQuery(this).attr(types[i] + 'set', srcset);
                    jQuery(this).attr('data-sizes', 'auto');
                }
            });
        }

        // jetpack
        jQuery('img[' + types[i] + '*=".wp.com/"]').each(function (index) {
            if (jQuery(this).attr('srcset') && jQuery(this).attr('data-srcset'))
                return;

            isMain = jQuery(this).parents('.woocommerce-product-gallery__image').length == 1;
            src = jQuery(this).attr(types[i])
            srcset = jQuery(this).attr(types[i] + 'set');

            if (!srcset && !isMain) {
                srcset = '';
                sizes = [75, 100, 150, 240, 320, 500, 640, 800, 1024, 1280, 1600];
                for (j = 0; j < sizes.length; j++) {
                    ssl = src.includes('ssl=1') ? '&ssl=1' : '';
                    srcset += ((j != 0) ? ', ' : '') + src.replace(src.split('?')[1], 'w=' + sizes[j] + '&resize=' + sizes[j] + ssl) + ' ' + sizes[j] + 'w';
                }
                jQuery(this).attr(types[i] + 'set', srcset);
                jQuery(this).attr('data-sizes', 'auto');
            }
        });

        // unsplash (it should not be used when there are image dimensions)
        // jQuery('img[' + types[i] + '^="https://images.unsplash.com/"]').each(function (index) {
        //     isMain = jQuery(this).parents('.woocommerce-product-gallery__image').length == 1;
        //     src = jQuery(this).attr(types[i])
        //     srcset = jQuery(this).attr(types[i] + 'set');

        //     if (!srcset && !isMain) {
        //         srcset = '';
        //         sizes = [75, 100, 150, 240, 320, 500, 640, 800, 1024, 1280, 1600];
        //         for (j = 0; j < sizes.length; j++)
        //             srcset += ((j != 0) ? ', ' : '') + src.replace(/&w=[0-9]+/, '&w=' + sizes[j]) + ' ' + sizes[j] + 'w';
        //         jQuery(this).attr(types[i] + 'set', srcset);
        //         jQuery(this).attr('data-sizes', 'auto');
        //     }
        // });
    }
}

document.addEventListener('lazybeforeunveil', function (e) {
    // background-image    
    var url = jQuery(e.target).attr('data-bg');
    if (url) {
        delimiter = fifu_get_delimiter(jQuery(e.target), 'data-bg');
        jQuery(e.target).css('background-image', 'url(' + fifu_get_delimited_url(url, delimiter) + ')');
    }

    // width & height
    // jQuery(e.target).attr('fifu-width', e.srcElement.clientWidth);
    // jQuery(e.target).attr('fifu-height', e.srcElement.clientHeight);

    // for background-videos
    clazz = jQuery(e.target).attr('class');
    if (clazz && clazz.includes('fifu-video') && typeof replaceVideoThumb === "function")
        replaceVideoThumb($);
});

document.addEventListener('lazyunveilread', function (e) {
});

function fifu_get_delimiter($, attr) {
    return $[0].outerHTML.split(attr + '=')[1][0];
}

function fifu_get_delimited_url(url, delimiter) {
    return delimiter + url + delimiter;
}

jQuery(document).on('lazybeforesizes', function (e) {
    // dont touch on fifu gallery
    if (jQuery(e.target).parent().hasClass('lslide'))
        return;

    // fix width and height fields, for SEO reasons
    dataSrc = jQuery(e.target).attr('data-src');
    if (dataSrc && dataSrc.includes('cdn.fifu.app')) {
        lsWidth = jQuery(e.target)[0].width;
        urlWidth = dataSrc.split('-')[1];
        urlHeight = dataSrc.split('-')[2].split('?')[0];
        newHeight = parseInt(lsWidth * urlHeight / urlWidth);
        jQuery(e.target).attr('width', lsWidth);
        jQuery(e.target).attr('height', newHeight);
    }
});

function fifu_lazy_ajax(selector = 'img') {
    jQuery(selector).each(function () {
        if (jQuery(this).hasClass('lazyload') || jQuery(this).hasClass('lazyloaded') || jQuery(this).hasClass('lazyloading'))
            return;

        src = jQuery(this).attr('src');
        if (src && src.includes('cloud.fifu.app'))
            return;

        jQuery(this).attr('data-src', jQuery(this).attr('src'));
        jQuery(this).removeAttr('src');
    });
    fifu_lazy(selector);
}
