<?php

/*
 * Plugin Name: Featured Image from URL (FIFU) Premium
 * Plugin URI: https://fifu.app/
 * Description: Use an external image/video as featured image/video of a post or WooCommerce product.
 * Version: 5.5.7
 * Author: fifu.app
 * Author URI: https://fifu.app/
 * WC requires at least: 4.0
 * WC tested up to: 6.3.1
 * Text Domain: fifu-premium
 */
define('FIFU_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FIFU_INCLUDES_DIR', FIFU_PLUGIN_DIR . 'includes');
define('FIFU_ADMIN_DIR', FIFU_PLUGIN_DIR . 'admin');
define('FIFU_ELEMENTOR_DIR', FIFU_PLUGIN_DIR . 'elementor');
define('FIFU_DELETE_ALL_URLS', false);
define('FIFU_CLOUD_KEY', pack("H*", ''));
define('FIFU_CLOUD_SALT', pack("H*", ''));

require_once (FIFU_INCLUDES_DIR . '/attachment.php');
require_once (FIFU_INCLUDES_DIR . '/bbpress.php');
require_once (FIFU_INCLUDES_DIR . '/convert-url.php');
require_once (FIFU_INCLUDES_DIR . '/external-post.php');
require_once (FIFU_INCLUDES_DIR . '/flickr.php');
require_once (FIFU_INCLUDES_DIR . '/jetpack.php');
require_once (FIFU_INCLUDES_DIR . '/rest.php');
require_once (FIFU_INCLUDES_DIR . '/shortcode.php');
require_once (FIFU_INCLUDES_DIR . '/speedup.php');
require_once (FIFU_INCLUDES_DIR . '/thumbnail.php');
require_once (FIFU_INCLUDES_DIR . '/thumbnail-category.php');
require_once (FIFU_INCLUDES_DIR . '/util.php');
require_once (FIFU_INCLUDES_DIR . '/video.php');
require_once (FIFU_INCLUDES_DIR . '/woo.php');

require_once (FIFU_ADMIN_DIR . '/amazon.php');
require_once (FIFU_ADMIN_DIR . '/api.php');
require_once (FIFU_ADMIN_DIR . '/books.php');
require_once (FIFU_ADMIN_DIR . '/category.php');
require_once (FIFU_ADMIN_DIR . '/column.php');
require_once (FIFU_ADMIN_DIR . '/cron.php');
require_once (FIFU_ADMIN_DIR . '/db.php');
require_once (FIFU_ADMIN_DIR . '/ddg.php');
require_once (FIFU_ADMIN_DIR . '/finder.php');
require_once (FIFU_ADMIN_DIR . '/lightbox.php');
require_once (FIFU_ADMIN_DIR . '/media-library.php');
require_once (FIFU_ADMIN_DIR . '/menu.php');
require_once (FIFU_ADMIN_DIR . '/meta-box.php');
require_once (FIFU_ADMIN_DIR . '/proxy.php');
require_once (FIFU_ADMIN_DIR . '/rsa.php');
require_once (FIFU_ADMIN_DIR . '/strings.php');
require_once (FIFU_ADMIN_DIR . '/widgets.php');
require_once (FIFU_ADMIN_DIR . '/wai-addon.php');

require_once (FIFU_ELEMENTOR_DIR . '/elementor-fifu-extension.php');

if (defined('WP_CLI') && WP_CLI)
    require_once (FIFU_ADMIN_DIR . '/cli-commands.php');

register_activation_hook(__FILE__, 'fifu_activate');

function fifu_activate($network_wide) {
    if (is_multisite() && $network_wide) {
        global $wpdb;
        foreach ($wpdb->get_col("SELECT blog_id FROM $wpdb->blogs") as $blog_id) {
            switch_to_blog($blog_id);
            fifu_activate_actions();
        }
    } else {
        fifu_activate_actions();
    }
    update_option('fifu_activation_time', time(), 'no');
}

function fifu_activate_actions() {
    update_option('fifu_update_all', 'toggleoff', 'no');
    fifu_db_change_url_length();

    if (!get_option('fifu_install'))
        update_option('fifu_install', date('Y-m-d H:i:s'), 'no');
}

register_deactivation_hook(__FILE__, 'fifu_deactivation');

function fifu_deactivation() {
    if (fifu_is_on('fifu_cron_metadata'))
        wp_clear_scheduled_hook('fifu_create_metadata_event');

    wp_clear_scheduled_hook('fifu_create_auto_set_event');

    wp_clear_scheduled_hook('fifu_create_isbn_event');

    wp_clear_scheduled_hook('fifu_create_screenshot_event');

    wp_clear_scheduled_hook('fifu_create_screenshot_refresh_event');

    wp_clear_scheduled_hook('fifu_create_finder_event');

    wp_clear_scheduled_hook('fifu_create_tags_event');

    wp_clear_scheduled_hook('fifu_create_upload_event');
}

add_action('upgrader_process_complete', 'fifu_upgrade', 10, 2);

function fifu_upgrade($upgrader_object, $options) {
    $current_plugin_path_name = plugin_basename(__FILE__);
    if ($options['action'] == 'update' && $options['type'] == 'plugin') {
        foreach ((array) $options['plugins'] as $each_plugin) {
            if ($each_plugin == $current_plugin_path_name) {
                fifu_db_change_url_length();
                fifu_db_update_autoload();
                fifu_db_delete_deprecated_data();
            }
        }
    }
    if ($options['type'] == 'core') {
        fifu_db_change_url_length();
        fifu_db_fix_guid();
    }
}

add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'fifu_action_links');
add_filter('network_admin_plugin_action_links_' . plugin_basename(__FILE__), 'fifu_action_links');

function fifu_action_links($links) {
    $links[] = '<a href="' . esc_url(get_admin_url(null, 'admin.php?page=fifu-premium')) . '">' . __('Settings') . '</a>';
    $links[] = '<a style="color:black">' . __('Support') . ':</a>';
    $links[] = '<br><center style="width:275px;color:white;background-color:#02a0d2;border-radius:0px 30px">support@featuredimagefromurl.com</center>';
    return $links;
}

add_action('fifu_event', 'fifu_event_function');

function fifu_event_function() {
    require_once (FIFU_ADMIN_DIR . '/menu.php');
    fifu_db_update_all();
}

require 'plugin-update-checker/plugin-update-checker.php';
$fifuUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
                'https://update.fifu.app/details',
                __FILE__,
                'fifu-premium'
);

// add the license key to query arguments
$fifuUpdateChecker->addQueryArgFilter('fifu_filter_update_checks');

function fifu_filter_update_checks($queryArgs) {
    $queryArgs['license_key'] = get_option('fifu_key');
    $queryArgs['domain'] = parse_url(get_site_url())['host'];
    return $queryArgs;
}

function fifu_check_updates($should_check, $arg1 = null, $arg2 = null) {
    if (get_option('fifu_activation_time')) {
        delete_option('fifu_activation_time');
        wp_cache_flush();
        return true;
    }
    return $should_check;
}

add_filter('puc_check_now-fifu-premium', 'fifu_check_updates', 10, 3);

function fifu_expired_row_meta($plugin_meta, $plugin_file, $plugin_data, $status) {
    if (strpos($plugin_file, 'fifu-premium.php') !== false) {
        if (get_option('fifu_expired'))
            $tag = '<a href="https://ws.featuredimagefromurl.com/keys/" target="_blank" style="color:#d63638"><b>Your license key has expired. Renew it here</b></a>';
        else {
            $tag = '<a href="https://ws.featuredimagefromurl.com/keys/" target="_blank">License key manager</a>';
        }
        $new_links = array(
            'renew' => $tag,
            'affiliate' => '<a href="https://referral.fifu.app" target="_blank">Affiliate program</a>',
        );
        $plugin_meta = array_merge($plugin_meta, $new_links);
    }
    return $plugin_meta;
}

add_filter('plugin_row_meta', 'fifu_expired_row_meta', 10, 4);

