<?php

add_action('add_meta_boxes', 'fifu_insert_meta_box');

function fifu_insert_meta_box() {
    if (get_option('fifu_lock'))
        return;

    $fifu = fifu_get_strings_meta_box_php();
    $post_types = fifu_get_post_types();

    foreach ($post_types as $post_type) {
        if ($post_type == 'product') {
            add_meta_box('urlMetaBox', $fifu['title']['product']['image'](), 'fifu_show_elements', $post_type, 'side', 'default');

            add_meta_box('wooGalleryMetaBox', $fifu['title']['product']['images'](), 'fifu_wc_show_elements', $post_type, 'side', 'default');

            if (fifu_is_on('fifu_video')) {
                add_meta_box('wooVideoUrlMetaBox', $fifu['title']['product']['video'](), 'fifu_video_show_elements', $post_type, 'side', 'default');
                add_meta_box('wooCommerceVideoGalleryMetaBox', $fifu['title']['product']['videos'](), 'fifu_video_wc_show_elements', $post_type, 'side', 'default');
            }

            if (fifu_is_on('fifu_slider'))
                add_meta_box('wooSliderImageUrlMetaBox', $fifu['title']['product']['slider'](), 'fifu_slider_show_elements', $post_type, 'side', 'default');

            if (fifu_is_on('fifu_shortcode'))
                add_meta_box('shortCodeMetaBox', $fifu['title']['post']['shortcode'](), 'fifu_shortcode_show_elements', $post_type, 'side', 'default');

            if (fifu_is_on('fifu_isbn'))
                add_meta_box('isbnMetaBox', $fifu['title']['post']['isbn'](), 'fifu_isbn_show_elements', $post_type, 'side', 'default');

            if (fifu_is_on('fifu_screenshot'))
                add_meta_box('screenshotMetaBox', $fifu['title']['post']['screenshot'](), 'fifu_screenshot_show_elements', $post_type, 'side', 'default');

            if (fifu_is_on('fifu_finder'))
                add_meta_box('finderMetaBox', $fifu['title']['post']['finder'](), 'fifu_finder_show_elements', $post_type, 'side', 'default');
        } else {
            if ($post_type) {
                add_meta_box('imageUrlMetaBox', $fifu['title']['post']['image'](), 'fifu_show_elements', $post_type, 'side', 'default');

                if (fifu_is_on('fifu_video'))
                    add_meta_box('videoUrlMetaBox', $fifu['title']['post']['video'](), 'fifu_video_show_elements', $post_type, 'side', 'default');

                if (fifu_is_on('fifu_slider'))
                    add_meta_box('sliderImageUrlMetaBox', $fifu['title']['post']['slider'](), 'fifu_slider_show_elements', $post_type, 'side', 'default');

                if (fifu_is_on('fifu_shortcode'))
                    add_meta_box('shortCodeMetaBox', $fifu['title']['post']['shortcode'](), 'fifu_shortcode_show_elements', $post_type, 'side', 'default');

                if (fifu_is_on('fifu_isbn'))
                    add_meta_box('isbnMetaBox', $fifu['title']['post']['isbn'](), 'fifu_isbn_show_elements', $post_type, 'side', 'default');

                if (fifu_is_on('fifu_screenshot'))
                    add_meta_box('screenshotMetaBox', $fifu['title']['post']['screenshot'](), 'fifu_screenshot_show_elements', $post_type, 'side', 'default');

                if (fifu_is_on('fifu_finder'))
                    add_meta_box('finderMetaBox', $fifu['title']['post']['finder'](), 'fifu_finder_show_elements', $post_type, 'side', 'default');

                if (fifu_is_on('fifu_redirection'))
                    add_meta_box('redirectionMetaBox', $fifu['title']['post']['redirection'](), 'fifu_redirection_show_elements', $post_type, 'side', 'default');
            }
        }
    }
    fifu_register_meta_box_script();
}

add_action('add_meta_boxes', 'remove_metaboxes', 50);

function remove_metaboxes() {
    global $post;
    $url = get_post_meta($post->ID, 'fifu_image_url', true);
    $gallery_urls = fifu_get_gallery_urls($post->ID);
    if ($url) {
        remove_meta_box('postimagediv', 'product', 'side');
    }
    if ($gallery_urls) {
        remove_meta_box('woocommerce-product-images', 'product', 'side');
    }
}

function fifu_register_meta_box_script() {
    $fifu = fifu_get_strings_meta_box_php();
    $fifu_help = fifu_get_strings_help();

    if (!fifu_is_fusion_builder_active())
        wp_enqueue_script('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.11.2/js/all.min.js');

    wp_enqueue_script('fifu-cookie', 'https://cdnjs.cloudflare.com/ajax/libs/js-cookie/latest/js.cookie.min.js');

    wp_enqueue_script('jquery-block-ui', 'https://cdnjs.cloudflare.com/ajax/libs/jquery.blockUI/2.70/jquery.blockUI.min.js');
    wp_enqueue_style('fancy-box-css', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.css');
    wp_enqueue_script('fancy-box-js', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js');

    wp_enqueue_script('fifu-rest-route-js', plugins_url('/html/js/rest-route.js', __FILE__), array('jquery'), fifu_version_number());
    wp_enqueue_script('fifu-meta-box-js', plugins_url('/html/js/meta-box.js', __FILE__), array('jquery'), fifu_version_number());
    wp_enqueue_script('fifu-video-util-js', plugins_url('/html/js/video-util.js', __FILE__), array('jquery'), fifu_version_number());
    wp_enqueue_script('fifu-video-meta-box-js', plugins_url('/html/js/video-meta-box.js', __FILE__), array('jquery'), fifu_version_number());
    wp_enqueue_script('fifu-convert-url-js', plugins_url('/html/js/convert-url.js', __FILE__), array('jquery'), fifu_version_number());

    wp_register_style('fifu-unsplash-css', plugins_url('/html/css/unsplash.css', __FILE__), array(), fifu_version_number());
    wp_enqueue_style('fifu-unsplash-css');
    wp_enqueue_script('fifu-unsplash-js', plugins_url('/html/js/unsplash.js', __FILE__), array('jquery'), fifu_version_number());

    // register custom variables for the AJAX script
    wp_localize_script('fifu-rest-route-js', 'fifuScriptVars', [
        'restUrl' => esc_url_raw(rest_url()),
        'homeUrl' => esc_url_raw(home_url()),
        'nonce' => wp_create_nonce('wp_rest'),
    ]);

    $unsplash_size = get_option('fifu_unsplash_size');

    if (fifu_is_on('fifu_same_size') && get_option('fifu_fit') == 'cover') {
        $position_option = get_post_meta(get_the_ID(), 'fifu_position', true);
        $arr = $position_option ? explode(' ', $position_option) : array();
        $position_option = sizeof($arr) > 0 ? $arr[0] : 'center';
        $position_option_horizontal = sizeof($arr) > 1 ? $arr[1] : 'center';
    } else {
        $position_option = '';
        $position_option_horizontal = '';
    }

    if (fifu_is_sirv_active())
        wp_enqueue_script('fifu-sirv-js', 'https://scripts.sirv.com/sirv.js');

    wp_localize_script('fifu-meta-box-js', 'fifuMetaBoxVars', [
        'unsplash_size' => $unsplash_size ? $unsplash_size : 'featured',
        'fifu_su_sign_up_complete' => fifu_su_sign_up_complete(),
        'get_the_ID' => get_the_ID(),
        'position_option' => $position_option,
        'position_option_horizontal' => $position_option_horizontal,
        'is_sirv_active' => fifu_is_sirv_active(),
        'wait' => $fifu['common']['wait'](),
        'is_taxonomy' => get_current_screen()->taxonomy,
        'is_product' => get_post_type() == 'product',
        'is_classic_editor' => is_plugin_active('classic-editor/classic-editor.php'),
        'enable_upload' => fifu_is_on('fifu_upload_show'),
        'txt_title_examples' => $fifu_help['title']['examples'](),
        'txt_title_keywords' => $fifu_help['title']['keywords'](),
        'txt_title_more' => $fifu_help['title']['more'](),
        'txt_title_url' => $fifu_help['title']['url'](),
        'txt_desc_empty' => $fifu_help['desc']['empty'](),
        'txt_desc_size' => $fifu_help['desc']['size'](),
        'txt_desc_more' => $fifu_help['desc']['more'](),
    ]);

    wp_localize_script('fifu-video-meta-box-js', 'fifuVideoMetaBoxVars', [
        'restUrl' => esc_url_raw(rest_url()),
        'nonce' => wp_create_nonce('wp_rest'),
    ]);
}

add_action('add_meta_boxes', 'fifu_add_css');

function fifu_add_css() {
    wp_register_style('fifu-premium', plugins_url('/html/css/editor.css', __FILE__), array(), fifu_version_number());
    wp_enqueue_style('fifu-premium');
}

function fifu_show_elements($post) {
    $margin = 'margin-top:5px;margin-left:3px;';
    $width = 'width:100%;';
    $height = 'height:150px;';
    $align = 'text-align:left;';

    $url = get_post_meta($post->ID, 'fifu_image_url', true);
    $alt = get_post_meta($post->ID, 'fifu_image_alt', true);

    if ($url) {
        $show_button = 'display:none;';
        $show_alt = $show_image = $show_link = '';
    } else {
        $show_alt = $show_image = $show_link = 'display:none;';
        $show_button = '';
    }

    $show_upload = fifu_is_on('fifu_upload_show') ? '' : 'display:none';

    $show_ignore = fifu_is_on('fifu_get_first') || fifu_is_on('fifu_pop_first') || fifu_is_on('fifu_ovw_first') ? '' : 'display:none;';

    $check_ignore = fifu_is_on('fifu_check') ? 'checked' : '';

    $show_giphy = !fifu_is_on('fifu_giphy') || $url ? 'display:none;' : '';

    if (fifu_is_on('fifu_same_size') && get_option('fifu_fit') == 'cover') {
        $show_position = 'box-sizing:border-box';
        $position_option = get_post_meta($post->ID, 'fifu_position', true);
        $arr = $position_option ? explode(' ', $position_option) : array();
        $position_option = sizeof($arr) > 0 ? $arr[0] : 'center';
        $position_option_horizontal = sizeof($arr) > 1 ? $arr[1] : 'center';
    } else {
        $show_position = 'display:none';
        $position_option = '';
        $position_option_horizontal = '';
    }

    $fifu = fifu_get_strings_meta_box();
    include 'html/meta-box.html';
}

function fifu_shortcode_show_elements($post) {
    $width = 'width:100%;';
    $height = 'height:150px !important;';
    $align = 'text-align:left;';

    $ratio = get_post_meta($post->ID, 'fifu_shortcode_ratio', true);

    $url = get_post_meta($post->ID, 'fifu_shortcode', true);

    if ($url)
        $show_shortcode = $show_link = '';
    else
        $show_shortcode = $show_link = 'display:none;';

    $fifu = fifu_get_strings_meta_box();
    echo '<style>';
    include 'html/css/shortcode.css';
    echo '</style>';
    include 'html/meta-box-shortcode-settings.html';
    include 'html/meta-box-shortcode.html';
}

function fifu_isbn_show_elements($post) {
    $input_style = 'width:100%;font-size:13px;';
    $isbn = get_post_meta($post->ID, 'fifu_isbn', true);
    $show_isbn = $isbn ? '' : 'display:none;';
    include 'html/meta-box-isbn.html';
}

function fifu_screenshot_show_elements($post) {
    $input_style = 'width:100%;font-size:13px;';
    $screenshot = get_post_meta($post->ID, 'fifu_screenshot_url', true);
    $show_screenshot = $screenshot ? '' : 'display:none;';
    include 'html/meta-box-screenshot.html';
}

function fifu_finder_show_elements($post) {
    $input_style = 'width:100%;font-size:13px;';
    $finder = get_post_meta($post->ID, 'fifu_finder_url', true);
    $show_finder = $finder ? '' : 'display:none;';
    include 'html/meta-box-finder.html';
}

function fifu_redirection_show_elements($post) {
    $input_style = 'width:100%;font-size:13px;';
    $redirection = get_post_meta($post->ID, 'fifu_redirection_url', true);
    $show_redirection = $redirection ? '' : 'display:none;';
    include 'html/meta-box-redirection.html';
}

function fifu_video_show_elements($post) {
    $margin = 'margin-top:10px;';
    $width = 'width:100%;';
    $height = 'height:150px;';
    $align = 'text-align:left;';

    $url = get_post_meta($post->ID, 'fifu_video_url', true);

    if ($url) {
        $show_button = 'display:none;';
        $show_video = $show_link = '';
        if (fifu_is_local_video($url)) {
            $show_video_local = '';
            $show_video = 'display:none;';
        } else {
            $show_video = '';
            $show_video_local = 'display:none;';
        }
    } else {
        $show_video = $show_video_local = $show_link = 'display:none;';
        $show_button = '';
    }

    $fifu = fifu_get_strings_meta_box();
    include 'html/meta-box-video.html';
}

function fifu_wc_show_elements($post) {
    $margin = 'margin-top:1px;';
    $width = 'width:100%;';
    $height = 'height:150px;';
    $align = 'text-align:left;';
    $altWidth = 'width:86%;';

    $fifu = fifu_get_strings_meta_box();

    for ($i = 0; $i < get_option('fifu_spinner_image'); $i++) {
        $url[$i] = get_post_meta($post->ID, 'fifu_image_url_' . $i, true);
        $alt[$i] = get_post_meta($post->ID, 'fifu_image_alt_' . $i, true);

        if ($url[$i]) {
            $show_url[$i] = $show_button[$i] = 'display:none;';
            $show_alt[$i] = $show_image[$i] = $show_link[$i] = '';
        } else {
            $show_alt[$i] = $show_image[$i] = $show_link[$i] = 'display:none;';
            $show_url[$i] = $show_button[$i] = '';
        }

        include 'html/woo-meta-box.html';
    }
}

function fifu_video_wc_show_elements($post) {
    $margin = 'margin-top:1px;';
    $width = 'width:100%;';
    $height = 'height:150px;';
    $align = 'text-align:left;';

    $fifu = fifu_get_strings_meta_box();

    for ($i = 0; $i < get_option('fifu_spinner_video'); $i++) {
        $url[$i] = get_post_meta($post->ID, 'fifu_video_url_' . $i, true);

        if ($url[$i]) {
            $show_url[$i] = $show_button[$i] = 'display:none;';
            $show_video[$i] = $show_link[$i] = '';
        } else {
            $show_video[$i] = $show_link[$i] = 'display:none;';
            $show_url[$i] = $show_button[$i] = '';
        }

        include 'html/woo-meta-box-video.html';
    }
}

function fifu_slider_show_elements($post) {
    $margin = 'margin-top:1px;';
    $width = 'width:100%;';
    $height = 'height:150px;';
    $align = 'text-align:left;';
    $altWidth = 'width:83%;';
    $deleteWidth = 'width:14%;';

    $ratio = get_post_meta($post->ID, 'fifu_slider_ratio', true);

    $fifu = fifu_get_strings_meta_box();
    include 'html/meta-box-slider-settings.html';

    for ($i = 0; $i < get_option('fifu_spinner_slider'); $i++) {
        $url[$i] = get_post_meta($post->ID, 'fifu_slider_image_url_' . $i, true);
        $alt[$i] = get_post_meta($post->ID, 'fifu_slider_image_alt_' . $i, true);

        if ($url[$i]) {
            $show_url[$i] = $show_button[$i] = 'display:none;';
            $show_alt[$i] = $show_image[$i] = $show_link[$i] = '';
        } else {
            $show_alt[$i] = $show_image[$i] = $show_link[$i] = 'display:none;';
            $show_url[$i] = $show_button[$i] = '';
        }

        include 'html/meta-box-slider.html';
    }
}

add_filter('wp_insert_post_data', 'fifu_remove_first_image', 10, 2);

function fifu_remove_first_image($data, $postarr) {
    /* invalid or external or ignore */
    if (!$_POST || !isset($_POST['fifu_input_url']) || isset($_POST['fifu_ignore_auto_set']))
        return $data;

    $content = $postarr['post_content'];

    if (!$content)
        return $data;

    $contentClean = fifu_show_all_images($content);
    $contentClean = fifu_show_all_videos($contentClean);
    $data = str_replace($content, $contentClean, $data);

    $img = fifu_first_img_in_content($contentClean);
    $video = fifu_first_video_in_content($contentClean);

    if (!$img && !$video)
        return $data;

    // there is no iframe
    if (fifu_is_on('fifu_get_first') && strpos($video, 'iframe') === false) {
        if ((!$img && $video) || ($img && $video && fifu_is_on('fifu_video_priority')))
            return $data;
    }

    if ($img && $video)
        $media = fifu_is_on('fifu_video_priority') ? $video : $img;
    else
        $media = $img ? $img : $video;

    if (fifu_is_off('fifu_pop_first'))
        return str_replace($media, fifu_show_media($media), $data);

    return str_replace($media, fifu_hide_media($media), $data);
}

// for wp all import: avoid duplicated images
function fifu_has_properties() {
    if (fifu_is_ol_scrapes_active())
        return true;

    foreach ($_POST as $key => $value) {
        if (strpos($key, 'fifu') !== false)
            return true;
    }
    return false;
}

add_action('woocommerce_before_product_object_save', 'fifu_woocommerce_before_product_object_save');

function fifu_woocommerce_before_product_object_save($product) {
    // fix for images deleted from WooCommerce product gallery metabox
    $ids = $product->get_data()['gallery_image_ids'];
    if ($ids)
        update_post_meta($product->get_id(), 'fifu_tmp_product_image_gallery', implode(',', $ids));
}

add_action('save_post', 'fifu_save_properties');

function fifu_save_properties($post_id) {
    if (!$_POST || get_post_type($post_id) == 'nav_menu_item' || get_post_type($post_id) == 'revision')
        return;

    if (isset($_POST['action']) && $_POST['action'] == 'woocommerce_do_ajax_product_import')
        return;

    if (!fifu_has_properties())
        return;

    $date = get_option('fifu_install');

    $ignore = false;
    if (isset($_POST['fifu_ignore_auto_set']))
        $ignore = $_POST['fifu_ignore_auto_set'] == 'on';

    if (isset($_POST['fifu_input_position'])) {
        $position = $_POST['fifu_input_position'];
        $position_horizontal = $_POST['fifu_input_position_horizontal'];
        if ($position && in_array($position, array("center", "top", "bottom")) &&
                $position_horizontal && in_array($position_horizontal, array("center", "left", "right"))) {
            update_post_meta($post_id, 'fifu_position', $position . ' ' . $position_horizontal);
        }
    }

    /* image url */
    $url = null;
    if (isset($_POST['fifu_input_url'])) {
        $url = esc_url_raw(rtrim($_POST['fifu_input_url']));
        if (!$ignore) {
            $first_image = fifu_first_url_in_content($post_id, null, false);
            $first_video = fifu_first_url_in_content($post_id, null, true);

            if ($first_image && $first_video && fifu_is_on('fifu_video_priority'))
                return;

            if ($first_image && fifu_is_on('fifu_get_first') && (!$url || fifu_is_on('fifu_ovw_first')))
                $url = $first_image;
        }

        if (!$url && isset($_POST['fifu_shortcode_input']) && $_POST['fifu_shortcode_input'])
            $url = 'https://storage.googleapis.com/featuredimagefromurl/shortcode.svg';

        fifu_update_or_delete($post_id, 'fifu_image_url', $url);
    }

    /* image url from wcfm */
    if (!$url && fifu_is_wcfm_active() && isset($_POST['wcfm_products_manage_form'])) {
        $url = esc_url_raw(rtrim(fifu_get_wcfm_url($_POST['wcfm_products_manage_form'])));
        if ($url)
            fifu_update_or_delete($post_id, 'fifu_image_url', $url);
    }

    /* image url from toolset forms */
    if (fifu_is_toolset_active() && isset($_POST['wpcf-fifu_image_url'])) {
        $url = esc_url_raw(rtrim($_POST['wpcf-fifu_image_url']));
        if ($url)
            fifu_update_or_delete($post_id, 'fifu_image_url', $url);
    }

    /* image url from aliplugin */
    if (fifu_is_aliplugin_active() && isset($_POST['imageUrl'])) {
        $url = esc_url_raw(rtrim($_POST['imageUrl']));
        if ($url)
            fifu_update_or_delete($post_id, 'fifu_image_url', $url);
    }

    /* image url from external form: user-submitted-posts */
    if (!$url && isset($_POST['fifu_image_url']) && !is_array($_POST['fifu_image_url'])) {
        $url = esc_url_raw(rtrim($_POST['fifu_image_url']));
        if ($url)
            fifu_update_or_delete($post_id, 'fifu_image_url', $url);
    }

    /* alt */
    if (isset($_POST['fifu_input_alt'])) {
        $alt = wp_strip_all_tags($_POST['fifu_input_alt']);
        $alt = !$alt && $url && fifu_is_on('fifu_auto_alt') ? get_the_title() : $alt;
        fifu_update_or_delete_value($post_id, 'fifu_image_alt', $alt);
    }

    /* isbn */
    if (isset($_POST['fifu_input_isbn'])) {
        $isbn = wp_strip_all_tags(trim($_POST['fifu_input_isbn']));
        fifu_update_or_delete_value($post_id, 'fifu_isbn', $isbn);
    }

    /* screenshot */
    if (isset($_POST['fifu_input_screenshot'])) {
        $page_url = esc_url_raw(rtrim($_POST['fifu_input_screenshot']));
        fifu_update_or_delete($post_id, 'fifu_screenshot_url', $page_url);
        delete_post_meta($post_id, 'fifu_screenshot_date');
    }

    /* finder */
    if (isset($_POST['fifu_input_finder'])) {
        $page_url = esc_url_raw(rtrim($_POST['fifu_input_finder']));
        fifu_update_or_delete($post_id, 'fifu_finder_url', $page_url);
    }

    /* redirection */
    if (isset($_POST['fifu_input_redirection'])) {
        $page_url = esc_url_raw(rtrim($_POST['fifu_input_redirection']));
        fifu_update_or_delete($post_id, 'fifu_redirection_url', $page_url);
    }

    /* gallery */
    if (get_post_type(get_the_ID()) == 'product') {
        for ($i = 0; $i < get_option('fifu_spinner_image'); $i++) {
            if (isset($_POST['fifu_input_url_' . $i]) && isset($_POST['fifu_input_alt_' . $i])) {
                $url = esc_url_raw(rtrim($_POST['fifu_input_url_' . $i]));
                $alt = wp_strip_all_tags($_POST['fifu_input_alt_' . $i]);
                fifu_update_or_delete($post_id, 'fifu_image_url_' . $i, $url);
                fifu_update_or_delete_value($post_id, 'fifu_image_alt_' . $i, $alt);
            }
        }
    }

    fifu_save($post_id, $ignore);

    /* dimensions featured */
    $width = fifu_get_width_meta($_POST);
    $height = fifu_get_height_meta($_POST);
    $att_id = get_post_thumbnail_id($post_id);
    fifu_save_dimensions($att_id, $width, $height);

    /* dimensions slider */
    $width = fifu_get_width_meta_slider($_POST);
    $height = fifu_get_height_meta_slider($_POST);
    for ($i = 0; $i < sizeof($width); $i++) {
        $att_id = fifu_db_get_att_id($post_id, esc_url_raw(rtrim($_POST['fifu_slider_input_url_' . $i])), false);
        fifu_save_dimensions($att_id, $width[$i], $height[$i]);
    }

    /* dimensions image gallery */
    $width = fifu_get_width_meta_image_gallery($_POST);
    $height = fifu_get_height_meta_image_gallery($_POST);
    for ($i = 0; $i < sizeof($width); $i++) {
        $att_id = fifu_db_get_att_id($post_id, esc_url_raw(rtrim($_POST['fifu_input_url_' . $i])), false);
        fifu_save_dimensions($att_id, $width[$i], $height[$i]);
    }

    /* dimensions video gallery */
    $width = fifu_get_width_meta_video_gallery($_POST);
    $height = fifu_get_height_meta_video_gallery($_POST);
    for ($i = 0; $i < sizeof($width); $i++) {
        $image_url = esc_url_raw(rtrim($_POST['fifu_video_input_image_src_' . $i]));
        $att_id = fifu_db_get_att_id($post_id, $image_url, false);
        if (!$att_id)
            $att_id = fifu_db_get_att_id($post_id, str_replace('mqdefault', 'maxresdefault', $image_url), false);
        fifu_save_dimensions($att_id, $width[$i], $height[$i]);
    }

    /* featured video (youtube dimensions) */
    if (isset($_POST['fifu_video_input_url']) && isset($_POST['fifu_video_input_image_src'])) {
        $video_url = esc_url_raw(rtrim($_POST['fifu_video_input_url']));
        $image_url = esc_url_raw(rtrim($_POST['fifu_video_input_image_src']));
        if (fifu_is_youtube_video($video_url)) {
            $att_id = get_post_thumbnail_id($post_id);
            fifu_updade_youtube_dimensions($att_id, $image_url);
        }
    }

    /* video gallery (youtube dimensions) */
    $width = fifu_get_width_meta_video_gallery($_POST);
    for ($i = 0; $i < sizeof($width); $i++) {
        $video_url = esc_url_raw(rtrim($_POST['fifu_video_input_url_' . $i]));
        $image_url = esc_url_raw(rtrim($_POST['fifu_video_input_image_src_' . $i]));
        if (fifu_is_youtube_video($video_url)) {
            $att_id = fifu_db_get_att_id($post_id, $image_url, false);
            if (!$att_id)
                $att_id = fifu_db_get_att_id($post_id, str_replace('mqdefault', 'maxresdefault', $image_url), false);
            fifu_updade_youtube_dimensions($att_id, $image_url);
        }
    }

    fifu_check_legacy_status($date);
}

function fifu_save_dimensions($att_id, $width, $height) {
    if (!$att_id || !$width || !$height)
        return;

    $metadata = null;
    $metadata['width'] = $width;
    $metadata['height'] = $height;

    // https://developer.wordpress.org/reference/functions/wp_get_attachment_metadata/
    // $url = wp_get_attachment_url($att_id);
    // if (fifu_is_from_speedup($url)) {
    //     // original dimensions
    //     $aux = explode('-', $url);
    //     $original_width = $aux[1];
    //     $original_height = explode('/', $aux[2])[0];
    //     $sizes = array();
    //     $subsizes = wp_get_registered_image_subsizes();
    //     foreach ($subsizes as $key => $value) {
    //         $width = $value['width'];
    //         $height = $value['height'];
    //         foreach (unserialize(FIFU_SPEEDUP_SIZES) as $i) {
    //             if ($width <= $i) {
    //                 if ($i < $original_width) {
    //                     $new_url = str_replace('original', $i, $url);
    //                     // adjust sizes
    //                     if ($height)
    //                         $height = $i * $height / $width;
    //                     else
    //                         $height = $i * $original_height / $original_width;
    //                     $width = $i;
    //                 }
    //                 break;
    //             }
    //         }
    //         $value['file'] = $new_url;
    //         $value['width'] = $width;
    //         $value['height'] = (int) $height;
    //         $value['mime-type'] = 'image/webp';
    //         unset($value['crop']);
    //         $sizes[$key] = $value;
    //     }
    //     $metadata['sizes'] = $sizes;
    //     $metadata['file'] = $url;
    // }

    wp_update_attachment_metadata($att_id, $metadata);
}

function fifu_save($post_id, $ignore) {
    fifu_video_save_properties($post_id, $ignore);
    fifu_slider_save_properties($post_id);

    fifu_update_fake_attach_id($post_id);

    fifu_shortcode_save_properties($post_id);

    if (fifu_is_on('fifu_auto_category'))
        fifu_db_insert_auto_category_image();
}

function fifu_video_save_properties($post_id, $ignore) {
    /* video url */
    if (isset($_POST['fifu_video_input_url'])) {
        $url = esc_url_raw(rtrim($_POST['fifu_video_input_url']));
        $first_image = fifu_first_url_in_content($post_id, null, false);
        $first_video = fifu_first_url_in_content($post_id, null, true);

        if (fifu_is_on('fifu_get_first') && $first_image && $first_video && fifu_is_off('fifu_video_priority'))
            return;

        if ($first_video && fifu_is_on('fifu_video') && fifu_is_on('fifu_get_first') && (!$url || fifu_is_on('fifu_ovw_first')) && !$ignore)
            $url = $first_video;

        fifu_update_or_delete($post_id, 'fifu_video_url', $url);
        if ($url) {
            fifu_update_or_delete($post_id, 'fifu_image_url', '');

            /* captured video thumbnail */
            if (isset($_POST['fifu_video_captured_frame'])) {
                $frame = $_POST['fifu_video_captured_frame'];
                if ($frame)
                    fifu_upload_captured_iframe($frame, $url);
            }
        }
    } else {
        // instagram
        $url = get_post_meta($post_id, 'fifu_video_url', true);
        if ($url && fifu_is_instagram_url($url)) {
            fifu_update_or_delete($post_id, 'fifu_video_url', '');
            fifu_update_or_delete($post_id, 'fifu_image_url', $url);
        }
    }

    /* gallery */
    if (get_post_type(get_the_ID()) == 'product') {
        for ($i = 0; $i < get_option('fifu_spinner_video'); $i++) {
            if (isset($_POST['fifu_video_input_url_' . $i])) {
                $url = esc_url_raw(rtrim($_POST['fifu_video_input_url_' . $i]));
                fifu_update_or_delete($post_id, 'fifu_video_url_' . $i, $url);
            }
        }
    }
}

function fifu_slider_save_properties($post_id) {
    /* ratio */
    $ratio = isset($_POST['fifu_slider_input_ratio']) ? $_POST['fifu_slider_input_ratio'] : '';
    fifu_update_or_delete_value($post_id, 'fifu_slider_ratio', $ratio);

    /* slider */
    for ($i = 0; $i < get_option('fifu_spinner_slider'); $i++) {
        if (isset($_POST['fifu_slider_input_url_' . $i]) && isset($_POST['fifu_slider_input_alt_' . $i])) {
            $url = esc_url_raw(rtrim($_POST['fifu_slider_input_url_' . $i]));
            $alt = wp_strip_all_tags($_POST['fifu_slider_input_alt_' . $i]);
            fifu_update_or_delete($post_id, 'fifu_slider_image_url_' . $i, $url);
            fifu_update_or_delete_value($post_id, 'fifu_slider_image_alt_' . $i, $alt);
        }
    }
}

function fifu_shortcode_save_properties($post_id) {
    /* ratio */
    $ratio = isset($_POST['fifu_shortcode_input_ratio']) ? $_POST['fifu_shortcode_input_ratio'] : '';
    fifu_update_or_delete_value($post_id, 'fifu_shortcode_ratio', $ratio);

    /* shortcode */
    if (isset($_POST['fifu_shortcode_input'])) {
        $url = $_POST['fifu_shortcode_input'];
        $url = preg_replace("/[\"]/", "'", $url);
        fifu_update_or_delete($post_id, 'fifu_shortcode', $url);
        set_post_thumbnail($post_id, 0);
    }
}

function fifu_update_or_delete_var($post_id, $field, $url) {
    if ($url && fifu_valid_url($url))
        update_post_meta($post_id, $field, fifu_convert($url));
    else
        delete_post_meta($post_id, $field);
    fifu_update_fake_attach_id($post_id);
}

function fifu_update_or_delete($post_id, $field, $url) {
    if ($url && fifu_valid_url($url)) {
        update_post_meta($post_id, $field, $field != 'fifu_video_url' ? fifu_convert($url) : $url);
    } else
        delete_post_meta($post_id, $field, $url);
}

function fifu_update_or_delete_value($post_id, $field, $value) {
    if ($value)
        update_post_meta($post_id, $field, $value);
    else
        delete_post_meta($post_id, $field, $value);
}

function fifu_update_or_delete_ctgr($post_id, $field, $url) {
    if ($url && fifu_valid_url($url)) {
        update_term_meta($post_id, $field, $field != 'fifu_video_url' ? fifu_convert($url) : $url);
    } else
        delete_term_meta($post_id, $field, $url);
}

add_action('pmxi_before_xml_import', 'fifu_before_xml_import', 10, 1);

function fifu_before_xml_import($import_id) {
    if (fifu_is_on('fifu_auto_category')) {
        update_option('fifu_auto_category', 'toggleoff');
        update_option('fifu_auto_category_waiting', true);
    }
}

add_action('pmxi_after_xml_import', 'fifu_after_xml_import', 10, 1);

function fifu_after_xml_import($import_id) {
    if (get_option('fifu_auto_category_waiting')) {
        update_option('fifu_auto_category', 'toggleon');
        fifu_db_insert_auto_category_image();
        update_option('fifu_auto_category_created', true, 'no');
        delete_option('fifu_auto_category_waiting');
    } else
        fifu_db_insert_attachment_category();
}

function fifu_wai_save($post_id, $is_ctgr) {
    $urls = rtrim(get_post_meta($post_id, 'fifu_list_url', true), '|');
    $alts = rtrim(get_post_meta($post_id, 'fifu_list_alt', true), '|');
    if ($urls) {
        $urls = explode("|", $urls);
        if ($alts)
            $alts = explode("|", $alts);
        $i = 0;
        $i_alt = 0;
        // check if there is featured video
        $has_main = fifu_is_on('fifu_video_list_priority') && rtrim(get_post_meta($post_id, 'fifu_list_video_url', true), '|');
        foreach ($urls as $url) {
            $url = trim($url);
            $alt = $alts && sizeof($alts) > $i_alt ? $alts[$i_alt++] : '';

            if (!$has_main) {
                if (fifu_valid_url($url)) {
                    fifu_update_or_delete($post_id, 'fifu_image_url', $url);
                    fifu_update_or_delete($post_id, 'fifu_image_alt', $alt);
                    $has_main = true;
                    delete_post_meta($post_id, 'fifu_video_url');
                }
            } else {
                if (fifu_valid_url($url)) {
                    fifu_update_or_delete($post_id, 'fifu_image_url_' . $i, $url);
                    fifu_update_or_delete($post_id, 'fifu_image_alt_' . $i, $alt);
                    $i++;
                }
            }
        }
        // update: remove extra fields
        while (true) {
            $url = get_post_meta($post_id, 'fifu_image_url_' . $i, true);
            if ($url) {
                delete_post_meta($post_id, 'fifu_image_url_' . $i);
                delete_post_meta($post_id, 'fifu_image_alt_' . $i);
            } else
                break;
            $i++;
        }
    } else {
        // fifu_list_url exists, but it's empty: delete all urls
        if (!empty(get_metadata('post', $post_id, 'fifu_list_url'))) {
            delete_post_meta($post_id, 'fifu_image_url');
            $i = 0;
            while (true) {
                $url = get_post_meta($post_id, 'fifu_image_url_' . $i, true);
                if ($url) {
                    delete_post_meta($post_id, 'fifu_image_url_' . $i);
                    delete_post_meta($post_id, 'fifu_image_alt_' . $i);
                } else
                    break;
                $i++;
            }
            delete_post_meta($post_id, 'fifu_list_url');
            delete_post_meta($post_id, 'fifu_list_alt');
        }

        $isbn = get_post_meta($post_id, 'fifu_isbn', true);
        fifu_update_or_delete($post_id, 'fifu_isbn', $isbn);

        $finder_url = get_post_meta($post_id, 'fifu_finder_url', true);
        if ($finder_url)
            update_post_meta($post_id, 'fifu_finder_url', $finder_url);
        else
            delete_post_meta($post_id, 'fifu_finder_url', $finder_url);

        $screenshot_url = get_post_meta($post_id, 'fifu_screenshot_url', true);
        if ($screenshot_url)
            update_post_meta($post_id, 'fifu_screenshot_url', $screenshot_url);
        else
            delete_post_meta($post_id, 'fifu_screenshot_url', $screenshot_url);


        if ($is_ctgr) {
            $url = get_term_meta($post_id, 'fifu_image_url', true);
            $alt = get_term_meta($post_id, 'fifu_image_alt', true);
            if (!fifu_valid_url($url)) {
                delete_term_meta($post_id, 'fifu_image_url', $url);
                delete_term_meta($post_id, 'fifu_image_alt', $alt);
            } else {
                fifu_update_or_delete_ctgr($post_id, 'fifu_image_url', $url);
                fifu_update_or_delete_ctgr($post_id, 'fifu_image_alt', $alt);
            }
        } else {
            $url = get_post_meta($post_id, 'fifu_image_url', true);
            $alt = get_post_meta($post_id, 'fifu_image_alt', true);
            if (!fifu_valid_url($url)) {
                delete_post_meta($post_id, 'fifu_image_url', $url);
                delete_post_meta($post_id, 'fifu_image_alt', $alt);
            } else {
                fifu_update_or_delete($post_id, 'fifu_image_url', $url);
                fifu_update_or_delete($post_id, 'fifu_image_alt', $alt);
            }
        }
    }
}

function fifu_wai_video_save($post_id, $is_ctgr) {
    $urls = get_post_meta($post_id, 'fifu_list_video_url', true);
    if ($urls) {
        $urls = explode("|", $urls);
        $i = 0;
        // check if there is featured image
        $has_main = fifu_is_off('fifu_video_list_priority') && rtrim(get_post_meta($post_id, 'fifu_list_url', true), '|');
        foreach ($urls as $url) {
            $url = trim($url);
            if (!$has_main) {
                fifu_update_or_delete($post_id, 'fifu_video_url', $url);
                $has_main = true;
                delete_post_meta($post_id, 'fifu_image_url');
            } else {
                fifu_update_or_delete($post_id, 'fifu_video_url_' . $i, $url);
                $i++;
            }
        }
        // update: remove extra fields
        while (true) {
            $url = get_post_meta($post_id, 'fifu_video_url_' . $i, true);
            if ($url)
                delete_post_meta($post_id, 'fifu_video_url_' . $i);
            else
                break;
            $i++;
        }
    } else {
        // fifu_list_video_url exists, but it's empty: delete all urls
        if (!empty(get_metadata('post', $post_id, 'fifu_list_video_url'))) {
            delete_post_meta($post_id, 'fifu_video_url');
            $i = 0;
            while (true) {
                $url = get_post_meta($post_id, 'fifu_video_url_' . $i, true);
                if ($url)
                    delete_post_meta($post_id, 'fifu_video_url_' . $i);
                else
                    break;
                $i++;
            }
            delete_post_meta($post_id, 'fifu_list_video_url');
        }

        if ($is_ctgr) {
            $url = get_term_meta($post_id, 'fifu_video_url', true);
            if ($url)
                fifu_update_or_delete_ctgr($post_id, 'fifu_video_url', $url);
        } else {
            $url = get_post_meta($post_id, 'fifu_video_url', true);
            if ($url)
                fifu_update_or_delete($post_id, 'fifu_video_url', $url);
        }
    }
}

function fifu_slider_wai_save($post_id) {
    $list = get_post_meta($post_id, 'fifu_slider_list_url', true);
    if ($list) {
        $list = explode("|", $list);
        $i = 0;
        foreach ($list as $url) {
            $url = trim($url);
            fifu_update_or_delete($post_id, 'fifu_slider_image_url_' . $i++, $url);
        }
    }
}

function fifu_split_lists($post_id) {
    fifu_wai_save($post_id, null);
    fifu_wai_video_save($post_id, null);
    fifu_slider_wai_save($post_id);
}

add_action('pmxi_saved_post', 'fifu_wai_xml_variations', 10, 3);

function fifu_wai_xml_variations($post_id, $xml_node, $is_update) {
    if (!class_exists('WooCommerce'))
        return;

    $product = wc_get_product($post_id);

    if (!$product)
        return;

    if (!$product->is_type('variable'))
        return;

    $record = json_decode(json_encode((array) $xml_node), 1);

    if (!isset($record['Extended_Xml_Attributes']))
        return;
    $variants = $record['Extended_Xml_Attributes']['variants']['variant'];

    // fix for single variant file
    if (!array_key_exists('0', $variants))
        $variants = array($variants);

    foreach ($variants as $variant) {
        $sku = $variant['sku'];
        if (!$sku)
            continue;

        $product_id = wc_get_product_id_by_sku($sku);
        if (!$product_id)
            continue;

        $fifu_list_url = $variant['fifu_list_url'];
        if (!$fifu_list_url)
            continue;

        fifu_dev_set_image_list($product_id, $fifu_list_url);
    }
}

add_action('before_delete_post', 'fifu_db_before_delete_post');

add_action('wp_trash_post', 'fifu_db_delete_category_image');

/* product variation, save metadata */

add_action('woocommerce_rest_insert_product_variation_object', 'fifu_save_product_variation', 10, 3);

function fifu_save_product_variation($object, $request, $insert) {
    fifu_save_product($object, $request, $insert);
    fifu_db_update_wc_additional_variation_images($object->id);
}

add_action('woocommerce_rest_insert_product_object', 'fifu_save_product', 10, 3);

function fifu_save_product($object, $request, $insert) {
    $post_id = $object->get_id();
    $alts = null;
    $urls = null;
    $is_slider = false;
    $is_video = false;
    $video_urls = null;

    foreach ($object->get_meta_data() as $data) {
        if ($data->key == 'fifu_image_url') {
            fifu_update_or_delete($post_id, 'fifu_image_url', $data->value);
            fifu_update_fake_attach_id($post_id);
        } else if ($data->key == 'fifu_video_url') {
            fifu_update_or_delete($post_id, 'fifu_video_url', $data->value);
            fifu_update_fake_attach_id($post_id);
        } else if ($data->key == 'fifu_list_alt')
            $alts = $data->value;
        else if ($data->key == 'fifu_list_url')
            $urls = $data->value;
        else if ($data->key == 'fifu_slider_list_url') {
            $urls = $data->value;
            $is_slider = true;
        } else if ($data->key == 'fifu_list_video_url') {
            $video_urls = $data->value;
            $is_video = true;
        }
    }
    $urls = array_filter(explode("|", $urls));
    $alts = array_filter(explode("|", $alts));
    $video_urls = $video_urls ? array_filter(explode("|", $video_urls)) : null;

    if ($insert)
        fifu_db_insert($post_id, $urls, $alts, $is_slider, $video_urls);
    else
        fifu_db_update($post_id, $urls, $alts, $is_slider, $video_urls);
}

add_action('woocommerce_rest_insert_product_cat', 'fifu_save_product_category', 10, 2);

function fifu_save_product_category($object, $request) {
    $params = $request->get_params();
    if (empty($params) || !isset($params['meta_data']))
        return;

    $term_id = $object->term_id;

    foreach ($params['meta_data'] as $meta) {
        if ($meta['key'] == 'fifu_image_url' || $meta['key'] == 'fifu_image_alt')
            update_term_meta($term_id, $meta['key'], $meta['value']);
    }
    fifu_db_ctgr_update_fake_attach_id($term_id);
}

/* regular woocommerce import */

add_action('woocommerce_product_import_inserted_product_object', 'fifu_woocommerce_import');

function fifu_woocommerce_import($object) {
    $post_id = $object->get_id();
    fifu_wai_save($post_id, null);
    fifu_wai_video_save($post_id, null);
    fifu_slider_wai_save($post_id);
    fifu_update_fake_attach_id($post_id);
}

/* plugin: wcfm */

function fifu_is_wcfm_active() {
    return is_plugin_active('wc-frontend-manager/wc_frontend_manager.php');
}

function fifu_get_wcfm_url($content) {
    $url = explode('fifu_image_url=', $content)[1];
    return $url ? urldecode(explode('&', $url)[0]) : null;
}

/* plugin: toolset forms */

function fifu_is_toolset_active() {
    return is_plugin_active('cred-frontend-editor/plugin.php');
}

/* plugin: aliplugin */

function fifu_is_aliplugin_active() {
    return is_plugin_active('aliplugin/aliplugin.php');
}

/* plugin: sirv */

function fifu_is_sirv_active() {
    return is_plugin_active('sirv/sirv.php');
}

/* woocommerce variation elements */

add_action('woocommerce_product_after_variable_attributes', 'fifu_variation_settings_fields', 10, 3);
add_action('woocommerce_save_product_variation', 'fifu_save_variation_settings_fields', 10, 2);
add_filter('woocommerce_available_variation', 'fifu_load_variation_settings_fields');
add_action('woocommerce_ajax_save_product_variations', 'fifu_after_save_variation_settings_fields', 10, 1);

function fifu_after_save_variation_settings_fields($product_id) {
    fifu_db_update_wc_additional_variation_images($product_id);
}

function fifu_variation_settings_fields($loop, $variation_data, $variation) {
    if (fifu_is_off('fifu_variation'))
        return;

    $fifu = fifu_get_strings_meta_box_php();

    // variation
    woocommerce_wp_text_input(
            array(
                'id' => "fifu_image_url{$loop}",
                'name' => "fifu_image_url[{$loop}]",
                'value' => get_post_meta($variation->ID, 'fifu_image_url', true),
                'label' => '<span class="dashicons dashicons-camera" style="font-size:20px"></span>' . $fifu['variation']['field'](),
                'desc_tip' => true,
                'description' => $fifu['variation']['info'](),
                'placeholder' => $fifu['variation']['image'](),
                'wrapper_class' => 'form-row form-row-full',
            )
    );
    woocommerce_wp_hidden_input(
            array(
                'id' => "fifu_var_input_width[{$loop}]",
                'name' => "fifu_var_input_width[{$loop}]",
            )
    );
    woocommerce_wp_hidden_input(
            array(
                'id' => "fifu_var_input_height[{$loop}]",
                'name' => "fifu_var_input_height[{$loop}]",
            )
    );

    // variation gallery
    for ($i = 0; $i < get_option('fifu_spinner_image'); $i++) {
        woocommerce_wp_text_input(
                array(
                    'id' => "fifu_image_url_" . $i . "{$loop}",
                    'name' => "fifu_image_url_" . $i . "[{$loop}]",
                    'value' => get_post_meta($variation->ID, 'fifu_image_url_' . $i, true),
                    'label' => '<span class="dashicons dashicons-format-gallery" style="font-size:20px"></span>' . $fifu['variation']['images']() . ' #' . ($i + 1),
                    'desc_tip' => true,
                    'placeholder' => $fifu['variation']['image'](),
                    'wrapper_class' => 'form-row form-row-full',
                )
        );
        woocommerce_wp_hidden_input(
                array(
                    'id' => "fifu_var_input_width_" . $i . "[{$loop}]",
                    'name' => "fifu_var_input_width_" . $i . "[{$loop}]",
                )
        );
        woocommerce_wp_hidden_input(
                array(
                    'id' => "fifu_var_input_height_" . $i . "[{$loop}]",
                    'name' => "fifu_var_input_height_" . $i . "[{$loop}]",
                )
        );
    }
    include 'html/woo-meta-box-variation.html';

    // upload
    if (fifu_is_on('fifu_upload_show')) {
        woocommerce_wp_checkbox(
                array(
                    'id' => "fifu_upload_cb",
                    'name' => "fifu_upload_cb",
                    'value' => false,
                    'label' => '<span class="dashicons dashicons-upload" style="font-size:20px"></span>' . $fifu['variation']['upload'](),
                )
        );
    }
}

function fifu_save_variation_settings_fields($variation_id, $loop) {
    // variation
    $url = esc_url_raw(rtrim($_POST['fifu_image_url'][$loop]));
    fifu_update_or_delete($variation_id, 'fifu_image_url', $url);
    fifu_update_or_delete($variation_id, 'fifu_image_alt', wc_get_product($variation_id)->get_title());

    // variation gallery
    for ($i = 0; $i < get_option('fifu_spinner_image'); $i++) {
        $url = esc_url_raw(rtrim($_POST['fifu_image_url_' . $i][$loop]));
        fifu_update_or_delete($variation_id, 'fifu_image_url_' . $i, $url);
        fifu_update_or_delete($variation_id, 'fifu_image_alt_' . $i, $url ? wc_get_product($variation_id)->get_title() : '');
    }

    fifu_update_fake_attach_id($variation_id);

    // dimensions (featured)
    $width = $_POST['fifu_var_input_width'][$loop];
    $height = $_POST['fifu_var_input_height'][$loop];
    $att_id = get_post_thumbnail_id($variation_id);
    fifu_save_dimensions($att_id, $width, $height);

    // dimensions (gallery)
    for ($i = 0; $i < get_option('fifu_spinner_image'); $i++) {
        $width = $_POST['fifu_var_input_width_' . $i][$loop];
        $height = $_POST['fifu_var_input_height_' . $i][$loop];
        $att_id = fifu_db_get_att_id($variation_id, esc_url_raw(rtrim($_POST['fifu_image_url_' . $i][$loop])), false);
        fifu_save_dimensions($att_id, $width, $height);
    }

    // upload
    if (isset($_POST['fifu_upload_cb']) && $_POST['fifu_upload_cb'] == 'yes') {
        $post_id = $variation_id;
        $url = get_post_meta($post_id, 'fifu_image_url', true);
        $alt = get_post_meta($post_id, 'fifu_image_alt', true);
        if (!$url)
            return;
        try {
            /* featured image */
            $att_id = fifu_upload_image($post_id, $url, $alt, false);
            if (!$att_id)
                throw new Exception('UPLOAD ERROR: ' . $url);
            update_post_meta($att_id, '_wp_attachment_image_alt', $alt);
            wp_update_post(array('ID' => $att_id, 'post_content' => $url));

            /* gallery */
            $i = 0;
            $gallery = fifu_db_get_image_gallery_urls($post_id);
            $att_ids = '';
            foreach ($gallery as $item) {
                $id = explode('_', $item->meta_key)[3];
                $gal_url = $item->meta_value;
                $gal_alt = get_post_meta($post_id, 'fifu_image_alt_' . $id, true);
                $gal_att_id = fifu_upload_image($post_id, $gal_url, $gal_alt, false);
                if (!$gal_att_id)
                    throw new Exception('UPLOAD ERROR: ' . $gal_url);
                update_post_meta($gal_att_id, '_wp_attachment_image_alt', $gal_alt);
                wp_update_post(array('ID' => $gal_att_id, 'post_content' => $gal_url));
                $att_ids .= ($i++ == 0) ? $gal_att_id : ',' . $gal_att_id;
            }
        } catch (Exception $e) {
            error_log($e->getMessage());
            error_log('ERROR: fifu_upload_image(' . $post_id . ')');
        }

        /* featured image */
        set_post_thumbnail($post_id, $att_id);
        delete_post_meta($post_id, 'fifu_image_url');
        delete_post_meta($post_id, 'fifu_image_alt');
        fifu_db_update_fake_attach_id($post_id);

        /* gallery */
        foreach ($gallery as $item) {
            $id = explode('_', $item->meta_key)[3];
            delete_post_meta($post_id, $item->meta_key);
            delete_post_meta($post_id, 'fifu_image_alt_' . $id);
        }
        update_post_meta($post_id, '_product_image_gallery', $att_ids);
        update_post_meta($post_id, '_wc_additional_variation_images', $att_ids);
    }
}

function fifu_load_variation_settings_fields($variation) {
    // variation
    $variation['fifu_image_url'] = get_post_meta($variation['variation_id'], 'fifu_image_url', true);

    // variation gallery
    for ($i = 0; $i < get_option('fifu_spinner_image'); $i++)
        $variation['fifu_image_url_' . $i] = get_post_meta($variation['variation_id'], 'fifu_image_url_' . $i, true);

    return $variation;
}

/* dimensions */

function fifu_get_width_meta($req) {
    if (isset($req['fifu_input_url']) && isset($req['fifu_input_image_width']) && $req['fifu_input_url'])
        return wp_strip_all_tags($req['fifu_input_image_width']);

    if (isset($req['fifu_video_input_url']) && isset($req['fifu_video_input_image_width']) && $req['fifu_video_input_url'])
        return wp_strip_all_tags($req['fifu_video_input_image_width']);

    return null;
}

function fifu_get_height_meta($req) {
    if (isset($req['fifu_input_url']) && isset($req['fifu_input_image_height']) && $req['fifu_input_url'])
        return wp_strip_all_tags($req['fifu_input_image_height']);

    if (isset($req['fifu_video_input_url']) && isset($req['fifu_video_input_image_height']) && $req['fifu_video_input_url'])
        return wp_strip_all_tags($req['fifu_video_input_image_height']);

    return null;
}

function fifu_get_width_meta_slider($req) {
    if (isset($req['fifu_slider_input_url_0'])) {
        $i = 0;
        $width = array();
        while (isset($req['fifu_slider_input_width_' . $i]))
            array_push($width, wp_strip_all_tags($req['fifu_slider_input_width_' . $i++]));
        return $width;
    }
    return array();
}

function fifu_get_height_meta_slider($req) {
    if (isset($req['fifu_slider_input_url_0'])) {
        $i = 0;
        $height = array();
        while (isset($req['fifu_slider_input_height_' . $i]))
            array_push($height, wp_strip_all_tags($req['fifu_slider_input_height_' . $i++]));
        return $height;
    }
    return array();
}

function fifu_get_width_meta_image_gallery($req) {
    if (isset($req['fifu_input_url_0'])) {
        $i = 0;
        $width = array();
        while (isset($req['fifu_input_width_' . $i]))
            array_push($width, wp_strip_all_tags($req['fifu_input_width_' . $i++]));
        return $width;
    }
    return array();
}

function fifu_get_height_meta_image_gallery($req) {
    if (isset($req['fifu_input_url_0'])) {
        $i = 0;
        $height = array();
        while (isset($req['fifu_input_height_' . $i]))
            array_push($height, wp_strip_all_tags($req['fifu_input_height_' . $i++]));
        return $height;
    }
    return array();
}

function fifu_get_width_meta_video_gallery($req) {
    if (isset($req['fifu_video_input_url_0'])) {
        $i = 0;
        $width = array();
        while (isset($req['fifu_video_input_width_' . $i]))
            array_push($width, wp_strip_all_tags($req['fifu_video_input_width_' . $i++]));
        return $width;
    }
    return array();
}

function fifu_get_height_meta_video_gallery($req) {
    if (isset($req['fifu_video_input_url_0'])) {
        $i = 0;
        $height = array();
        while (isset($req['fifu_video_input_height_' . $i]))
            array_push($height, wp_strip_all_tags($req['fifu_video_input_height_' . $i++]));
        return $height;
    }
    return array();
}

/* plugin: wordpress importer */

add_action('import_end', 'fifu_import_end', 10, 0);

function fifu_import_end() {
    if ($_POST['action'] == "woocommerce_csv_import_request" && !isset($_POST['mapping']))
        return;
    fifu_db_delete_thumbnail_id_without_attachment();
    fifu_db_insert_attachment();
    fifu_db_insert_attachment_category();
    fifu_db_insert_attachment_gallery();
}

/* plugin: yoast duplicate post */

function fifu_duplicate_post_meta_keys_filter($meta_keys) {
    $remove_thumbnail = false;
    $thumbnail_id = null;

    for ($i = 0; $i < count($meta_keys); $i++) {
        if (fifu_starts_with($meta_keys[$i], 'fifu'))
            $remove_thumbnail = true;
        elseif ($meta_keys[$i] == '_thumbnail_id')
            $thumbnail_id = $i;
    }

    if ($remove_thumbnail)
        unset($meta_keys[$thumbnail_id]);

    return $meta_keys;
}

add_filter('duplicate_post_meta_keys_filter', 'fifu_duplicate_post_meta_keys_filter');